@extends('layouts.app')

@section('title', $service->name_bn)

@section('content')
<!-- Page Header -->
<section class="py-20 bg-dark-light/50 relative overflow-hidden">
    <div class="absolute inset-0">
        <div class="absolute top-0 left-0 w-96 h-96 bg-primary/10 rounded-full filter blur-3xl"></div>
        <div class="absolute bottom-0 right-0 w-96 h-96 bg-secondary/10 rounded-full filter blur-3xl"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10">
        <div class="grid lg:grid-cols-2 gap-12 items-center">
            <div>
                <span class="inline-block bg-primary/20 text-primary px-4 py-2 rounded-full text-sm font-medium mb-4">
                    {{ $service->category->name_bn ?? 'প্রিমিয়াম সেবা' }}
                </span>
                <h1 class="text-3xl md:text-5xl font-bold mb-4">{{ $service->name_bn }}</h1>
                <p class="text-gray-400 text-lg mb-6">
                    {{ $service->short_description_bn }}
                </p>
                <div class="flex flex-wrap gap-4">
                    <a href="#order-form" class="bg-gradient-to-r from-primary to-secondary hover:from-primary/80 hover:to-secondary/80 text-white px-8 py-4 rounded-xl font-semibold transition-all duration-300 flex items-center gap-2">
                        <i class="fas fa-shopping-cart"></i>
                        সার্ভিস নিন
                    </a>
                    <a href="{{ route('contact') }}" class="bg-white/10 hover:bg-white/20 text-white px-8 py-4 rounded-xl font-semibold transition-colors flex items-center gap-2">
                        <i class="fas fa-question-circle"></i>
                        জিজ্ঞাসা করুন
                    </a>
                </div>
            </div>
            <div class="hidden lg:flex justify-center">
                <div class="relative">
                    <div class="w-80 h-80 bg-gradient-to-br from-primary/20 to-secondary/20 rounded-full filter blur-3xl absolute -inset-8"></div>
                    <div class="relative w-72 h-72 bg-dark rounded-3xl border border-white/10 flex items-center justify-center">
                        @if($service->image)
                            <img src="{{ asset('storage/' . $service->image) }}" alt="{{ $service->name_bn }}" class="w-full h-full object-cover rounded-3xl">
                        @else
                            <div class="text-center">
                                @if($service->icon)
                                    <i class="{{ $service->icon }} text-6xl text-primary mb-4"></i>
                                @else
                                    <i class="fas fa-cog text-6xl text-primary mb-4"></i>
                                @endif
                                <h3 class="text-xl font-bold">{{ $service->name_bn }}</h3>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Features Section -->
@if($service->features_bn)
<section class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <h2 class="text-2xl md:text-3xl font-bold mb-4">আমাদের {{ $service->name_bn }}</h2>
            <p class="text-gray-400">আমরা যে সেবাগুলো প্রদান করি</p>
        </div>
        
        <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
            @foreach($service->features_bn as $feature)
            <div class="bg-dark-light rounded-2xl p-6 border border-white/10 text-center">
                <div class="w-14 h-14 bg-primary/20 rounded-xl flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-check text-primary text-xl"></i>
                </div>
                <h3 class="font-semibold">{{ $feature }}</h3>
            </div>
            @endforeach
        </div>
    </div>
</section>
@endif

<!-- Why Choose Us -->
<section class="py-20 bg-dark-light/50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <h2 class="text-2xl md:text-3xl font-bold mb-4">কেন আমাদের সেবা নিবেন?</h2>
        </div>
        
        <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div class="bg-dark rounded-2xl p-6 border border-white/10 text-center">
                <div class="w-16 h-16 bg-green-500/20 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-shield-alt text-green-400 text-2xl"></i>
                </div>
                <h3 class="font-bold mb-2">১০০% নিরাপদ</h3>
                <p class="text-gray-400 text-sm">সম্পূর্ণ নিরাপত্তা নিশ্চয়তা</p>
            </div>
            <div class="bg-dark rounded-2xl p-6 border border-white/10 text-center">
                <div class="w-16 h-16 bg-blue-500/20 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-bolt text-blue-400 text-2xl"></i>
                </div>
                <h3 class="font-bold mb-2">দ্রুত সেবা</h3>
                <p class="text-gray-400 text-sm">২৪-৪৮ ঘন্টায় সম্পন্ন</p>
            </div>
            <div class="bg-dark rounded-2xl p-6 border border-white/10 text-center">
                <div class="w-16 h-16 bg-purple-500/20 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-users text-purple-400 text-2xl"></i>
                </div>
                <h3 class="font-bold mb-2">অভিজ্ঞ টিম</h3>
                <p class="text-gray-400 text-sm">৫+ বছরের অভিজ্ঞতা</p>
            </div>
            <div class="bg-dark rounded-2xl p-6 border border-white/10 text-center">
                <div class="w-16 h-16 bg-orange-500/20 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-percentage text-orange-400 text-2xl"></i>
                </div>
                <h3 class="font-bold mb-2">৯৮% সফলতা</h3>
                <p class="text-gray-400 text-sm">উচ্চ সফলতার হার</p>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-2 lg:grid-cols-4 gap-6">
            <div class="bg-dark-light rounded-2xl p-6 text-center border border-white/10">
                <div class="text-3xl md:text-4xl font-bold text-primary mb-2">2,000+</div>
                <p class="text-gray-400 text-sm">সফল ভেরিফিকেশন</p>
                <p class="text-xs text-gray-500">Blue Tick & Green Tick</p>
            </div>
            <div class="bg-dark-light rounded-2xl p-6 text-center border border-white/10">
                <div class="text-3xl md:text-4xl font-bold text-secondary mb-2">5,000+</div>
                <p class="text-gray-400 text-sm">সন্তুষ্ট গ্রাহক</p>
                <p class="text-xs text-gray-500">বিশ্বস্ত সেবা</p>
            </div>
            <div class="bg-dark-light rounded-2xl p-6 text-center border border-white/10">
                <div class="text-3xl md:text-4xl font-bold text-accent mb-2">98%</div>
                <p class="text-gray-400 text-sm">সফলতার হার</p>
                <p class="text-xs text-gray-500">গ্যারান্টিযুক্ত সেবা</p>
            </div>
            <div class="bg-dark-light rounded-2xl p-6 text-center border border-white/10">
                <div class="text-3xl md:text-4xl font-bold text-green-400 mb-2">24/7</div>
                <p class="text-gray-400 text-sm">সাপোর্ট</p>
                <p class="text-xs text-gray-500">গ্রাহক সেবা</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-20 bg-gradient-to-br from-primary/10 via-secondary/10 to-accent/10">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-2xl md:text-3xl font-bold mb-4">আজই শুরু করুন</h2>
        <p class="text-gray-400 max-w-2xl mx-auto mb-8">
            আপনার Meta প্ল্যাটফর্মগুলোকে প্রফেশনাল লেভেলে নিয়ে যান আমাদের বিশেষজ্ঞ সেবার মাধ্যমে।
        </p>
        <a href="#order-form" class="inline-flex items-center gap-2 bg-gradient-to-r from-primary to-secondary hover:from-primary/80 hover:to-secondary/80 text-white px-8 py-4 rounded-xl font-semibold transition-all duration-300">
            <i class="fas fa-rocket"></i>
            এখনই সেবা নিন
        </a>
    </div>
</section>

<!-- Order Form Section -->
<section id="order-form" class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        <div class="max-w-2xl mx-auto">
            <div class="text-center mb-10">
                <span class="inline-block bg-primary/20 text-primary px-4 py-2 rounded-full text-sm font-medium mb-4">
                    অর্ডার ফর্ম
                </span>
                <h2 class="text-2xl md:text-3xl font-bold mb-4">{{ $service->name_bn }} রিকুয়েস্ট ফর্ম</h2>
                <p class="text-gray-400">আপনার প্রয়োজনীয় তথ্য দিয়ে ফর্মটি পূরণ করুন।</p>
            </div>
            
            <div class="bg-dark-light rounded-2xl p-6 md:p-8 border border-white/10">
                @if(session('success'))
                <div class="bg-green-500/20 border border-green-500/50 text-green-400 px-4 py-3 rounded-xl mb-6">
                    <i class="fas fa-check-circle mr-2"></i>
                    {{ session('success') }}
                </div>
                @endif
                
                <form action="{{ route('orders.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="service_id" value="{{ $service->id }}">
                    
                    <div class="space-y-6">
                        <div>
                            <label class="block text-sm font-medium mb-2">আপনার নাম <span class="text-red-500">*</span></label>
                            <input type="text" name="customer_name" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="আপনার পূর্ণ নাম">
                            @error('customer_name')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">মোবাইল/হোয়াটসঅ্যাপ <span class="text-red-500">*</span></label>
                            <input type="tel" name="customer_phone" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="০১XXXXXXXXX">
                            @error('customer_phone')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">ইমেইল (ঐচ্ছিক)</label>
                            <input type="email" name="customer_email" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="your@email.com">
                            @error('customer_email')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">আইডি লিংক</label>
                            <input type="url" name="id_link" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="https://facebook.com/yourpage">
                            @error('id_link')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">সার্ভিস প্ল্যাটফর্ম</label>
                            <div class="grid grid-cols-3 gap-3">
                                <label class="flex items-center gap-2 bg-dark border border-white/10 rounded-xl px-4 py-3 cursor-pointer hover:border-primary/50 transition-colors">
                                    <input type="radio" name="platform" value="facebook" class="text-primary">
                                    <span>Facebook</span>
                                </label>
                                <label class="flex items-center gap-2 bg-dark border border-white/10 rounded-xl px-4 py-3 cursor-pointer hover:border-primary/50 transition-colors">
                                    <input type="radio" name="platform" value="instagram" class="text-primary">
                                    <span>Instagram</span>
                                </label>
                                <label class="flex items-center gap-2 bg-dark border border-white/10 rounded-xl px-4 py-3 cursor-pointer hover:border-primary/50 transition-colors">
                                    <input type="radio" name="platform" value="whatsapp" class="text-primary">
                                    <span>WhatsApp</span>
                                </label>
                            </div>
                            @error('platform')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">সেবার ধরন</label>
                            <div class="grid grid-cols-2 md:grid-cols-3 gap-3">
                                <label class="flex items-center gap-2 bg-dark border border-white/10 rounded-xl px-4 py-3 cursor-pointer hover:border-primary/50 transition-colors">
                                    <input type="radio" name="service_type" value="blue-tick" class="text-primary">
                                    <span>Blue Tick</span>
                                </label>
                                <label class="flex items-center gap-2 bg-dark border border-white/10 rounded-xl px-4 py-3 cursor-pointer hover:border-primary/50 transition-colors">
                                    <input type="radio" name="service_type" value="business-manager" class="text-primary">
                                    <span>Business Manager</span>
                                </label>
                                <label class="flex items-center gap-2 bg-dark border border-white/10 rounded-xl px-4 py-3 cursor-pointer hover:border-primary/50 transition-colors">
                                    <input type="radio" name="service_type" value="ad-account" class="text-primary">
                                    <span>Ad Account</span>
                                </label>
                                <label class="flex items-center gap-2 bg-dark border border-white/10 rounded-xl px-4 py-3 cursor-pointer hover:border-primary/50 transition-colors">
                                    <input type="radio" name="service_type" value="recovery" class="text-primary">
                                    <span>Recovery</span>
                                </label>
                                <label class="flex items-center gap-2 bg-dark border border-white/10 rounded-xl px-4 py-3 cursor-pointer hover:border-primary/50 transition-colors">
                                    <input type="radio" name="service_type" value="page-ban" class="text-primary">
                                    <span>Page Ban</span>
                                </label>
                                <label class="flex items-center gap-2 bg-dark border border-white/10 rounded-xl px-4 py-3 cursor-pointer hover:border-primary/50 transition-colors">
                                    <input type="radio" name="service_type" value="whatsapp-verify" class="text-primary">
                                    <span>WhatsApp Verify</span>
                                </label>
                                <label class="flex items-center gap-2 bg-dark border border-white/10 rounded-xl px-4 py-3 cursor-pointer hover:border-primary/50 transition-colors col-span-2 md:col-span-3">
                                    <input type="radio" name="service_type" value="other" class="text-primary">
                                    <span>অন্যান্য</span>
                                </label>
                            </div>
                            @error('service_type')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">সংক্ষিপ্ত বর্ণনা</label>
                            <textarea name="details" rows="4" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="আপনার প্রয়োজনীয় সেবা সম্পর্কে বিস্তারিত লিখুন..."></textarea>
                            @error('details')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">প্রয়োজনীয় ডকুমেন্ট</label>
                            <input type="file" name="document" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:bg-primary file:text-white hover:file:bg-primary/80 transition-colors">
                            @error('document')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">অগ্রাধিকার</label>
                            <div class="grid grid-cols-2 gap-3">
                                <label class="flex items-center gap-2 bg-dark border border-white/10 rounded-xl px-4 py-3 cursor-pointer hover:border-primary/50 transition-colors">
                                    <input type="radio" name="priority" value="normal" checked class="text-primary">
                                    <span>সাধারণ</span>
                                </label>
                                <label class="flex items-center gap-2 bg-dark border border-white/10 rounded-xl px-4 py-3 cursor-pointer hover:border-primary/50 transition-colors">
                                    <input type="radio" name="priority" value="urgent" class="text-primary">
                                    <span>জরুরি</span>
                                </label>
                            </div>
                            @error('priority')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="flex items-center gap-3 cursor-pointer">
                                <input type="checkbox" required class="w-5 h-5 rounded border-white/10 bg-dark text-primary focus:ring-primary">
                                <span class="text-sm text-gray-400">আমি নিশ্চিত করছি যে প্রদত্ত সকল তথ্য সঠিক।</span>
                            </label>
                        </div>
                        
                        <button type="submit" class="w-full bg-gradient-to-r from-primary to-secondary hover:from-primary/80 hover:to-secondary/80 text-white py-4 rounded-xl font-semibold transition-all duration-300 flex items-center justify-center gap-2">
                            <i class="fas fa-paper-plane"></i>
                            সার্ভিস নিন
                        </button>
                    </div>
                </form>
                
                <!-- Payment Notice -->
                <div class="mt-6 bg-yellow-500/10 border border-yellow-500/30 rounded-xl p-4">
                    <div class="flex items-start gap-3">
                        <i class="fas fa-info-circle text-yellow-500 mt-1"></i>
                        <div class="text-sm text-gray-400">
                            <p class="font-medium text-yellow-400 mb-1">পেমেন্ট গেটওয়ে নোটিশ</p>
                            <p>অর্ডার সম্পন্ন হওয়ার পর আপনার ইমেইল, SMS, অথবা WhatsApp এ অটোমেটিক পেমেন্ট লিংক চলে যাবে। সেখান থেকে পেমেন্ট সম্পন্ন করুন। ইমেইলে ইনবক্সে দেখা না গেলে স্প্যাম ফোল্ডার চেক করুন। ধন্যবাদ</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
