<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Mamun eService') - বাংলাদেশের সেরা ডিজিটাল সেবা প্রদানকারী</title>
    <meta name="description" content="@yield('meta_description', 'Mamun eService - বাংলাদেশের সেরা ডিজিটাল সেবা প্রদানকারী। Meta Service, রিচার্জ, VPN, সরকারি সেবা সব এক প্ল্যাটফর্মে।')">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('favicon.ico') }}">
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="{{ asset('css/style.css') }}">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#0ea5e9',
                        secondary: '#6366f1',
                        accent: '#8b5cf6',
                        dark: '#0f172a',
                        'dark-light': '#1e293b',
                    },
                    fontFamily: {
                        'bangla': ['Hind Siliguri', 'sans-serif'],
                        'english': ['Inter', 'sans-serif'],
                    }
                }
            }
        }
    </script>
    
    @stack('styles')
</head>
<body class="font-bangla bg-dark text-white antialiased">
    <!-- Header -->
    @include('partials.header')
    
    <!-- Main Content -->
    <main>
        @yield('content')
    </main>
    
    <!-- Footer -->
    @include('partials.footer')
    
    <!-- WhatsApp Float Button -->
    <a href="https://wa.me/8801886191222" target="_blank" class="fixed bottom-6 right-6 z-50 bg-green-500 hover:bg-green-600 text-white p-4 rounded-full shadow-lg transition-all duration-300 hover:scale-110">
        <i class="fab fa-whatsapp text-2xl"></i>
    </a>
    
    <!-- Scroll to Top Button -->
    <button id="scrollToTop" class="fixed bottom-6 right-20 z-50 bg-primary hover:bg-primary/80 text-white p-3 rounded-full shadow-lg transition-all duration-300 opacity-0 invisible">
        <i class="fas fa-arrow-up"></i>
    </button>
    
    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="{{ asset('js/main.js') }}"></script>
    
    @stack('scripts')
</body>
</html>
