@extends('layouts.app')

@section('title', 'নতুন সেবা')

@section('content')
<section class="py-10 bg-dark-light/50 border-b border-white/10">
    <div class="container mx-auto px-4">
        <div class="flex items-center gap-2 text-sm text-gray-400 mb-4">
            <a href="{{ route('admin.dashboard') }}" class="hover:text-white transition-colors">ড্যাশবোর্ড</a>
            <i class="fas fa-chevron-right text-xs"></i>
            <a href="{{ route('admin.services') }}" class="hover:text-white transition-colors">সেবাসমূহ</a>
            <i class="fas fa-chevron-right text-xs"></i>
            <span>নতুন সেবা</span>
        </div>
        <h1 class="text-2xl md:text-3xl font-bold">নতুন সেবা যোগ করুন</h1>
    </div>
</section>

<section class="py-10 bg-dark">
    <div class="container mx-auto px-4">
        <div class="max-w-3xl mx-auto">
            <div class="bg-dark-light rounded-2xl p-6 md:p-8 border border-white/10">
                <form action="{{ route('admin.services.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="space-y-6">
                        <div class="grid md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium mb-2">সেবার নাম (English) <span class="text-red-500">*</span></label>
                                <input type="text" name="name" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="Service Name">
                                @error('name')
                                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium mb-2">সেবার নাম (বাংলা) <span class="text-red-500">*</span></label>
                                <input type="text" name="name_bn" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="সেবার নাম">
                                @error('name_bn')
                                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">Slug <span class="text-red-500">*</span></label>
                            <input type="text" name="slug" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="service-slug">
                            @error('slug')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">ক্যাটাগরি <span class="text-red-500">*</span></label>
                            <select name="category_id" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white focus:outline-none focus:border-primary transition-colors">
                                <option value="">ক্যাটাগরি নির্বাচন করুন</option>
                                @foreach($categories as $category)
                                <option value="{{ $category->id }}">{{ $category->name_bn }}</option>
                                @endforeach
                            </select>
                            @error('category_id')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">সংক্ষিপ্ত বিবরণ (বাংলা)</label>
                            <textarea name="short_description_bn" rows="2" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="সংক্ষিপ্ত বিবরণ"></textarea>
                            @error('short_description_bn')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">বিস্তারিত বিবরণ (বাংলা)</label>
                            <textarea name="description_bn" rows="5" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="বিস্তারিত বিবরণ"></textarea>
                            @error('description_bn')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div class="grid md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium mb-2">ছবি</label>
                                <input type="file" name="image" accept="image/*" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:bg-primary file:text-white hover:file:bg-primary/80 transition-colors">
                                @error('image')
                                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium mb-2">Icon Class</label>
                                <input type="text" name="icon" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="fas fa-cog">
                                @error('icon')
                                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="grid md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium mb-2">সেবার ধরন <span class="text-red-500">*</span></label>
                                <select name="type" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white focus:outline-none focus:border-primary transition-colors">
                                    <option value="free">ফ্রি</option>
                                    <option value="paid">পেইড</option>
                                </select>
                                @error('type')
                                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium mb-2">বাহিরের লিংক</label>
                                <input type="url" name="external_link" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="https://example.com">
                                @error('external_link')
                                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="grid md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium mb-2">দাম</label>
                                <input type="number" name="price" step="0.01" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="0.00">
                                @error('price')
                                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium mb-2">ডিসকাউন্ট দাম</label>
                                <input type="number" name="discount_price" step="0.01" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="0.00">
                                @error('discount_price')
                                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="grid md:grid-cols-3 gap-6">
                            <div>
                                <label class="flex items-center gap-3 cursor-pointer">
                                    <input type="checkbox" name="is_featured" value="1" class="w-5 h-5 rounded border-white/10 bg-dark text-primary focus:ring-primary">
                                    <span class="text-sm">ফিচার্ড</span>
                                </label>
                            </div>
                            
                            <div>
                                <label class="flex items-center gap-3 cursor-pointer">
                                    <input type="checkbox" name="is_popular" value="1" class="w-5 h-5 rounded border-white/10 bg-dark text-primary focus:ring-primary">
                                    <span class="text-sm">জনপ্রিয়</span>
                                </label>
                            </div>
                            
                            <div>
                                <label class="flex items-center gap-3 cursor-pointer">
                                    <input type="checkbox" name="is_active" value="1" checked class="w-5 h-5 rounded border-white/10 bg-dark text-primary focus:ring-primary">
                                    <span class="text-sm">সক্রিয়</span>
                                </label>
                            </div>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">সর্ট অর্ডার</label>
                            <input type="number" name="sort_order" value="0" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors">
                            @error('sort_order')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div class="flex gap-4">
                            <button type="submit" class="flex-1 bg-gradient-to-r from-primary to-secondary hover:from-primary/80 hover:to-secondary/80 text-white py-4 rounded-xl font-semibold transition-all duration-300">
                                সেবা যোগ করুন
                            </button>
                            <a href="{{ route('admin.services') }}" class="px-8 py-4 bg-white/10 hover:bg-white/20 text-white rounded-xl transition-colors">
                                বাতিল
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
@endsection
