@extends('layouts.app')

@section('title', 'অর্ডারসমূহ')

@section('content')
<section class="py-10 bg-dark-light/50 border-b border-white/10">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <div>
                <h1 class="text-2xl md:text-3xl font-bold">অর্ডারসমূহ</h1>
                <p class="text-gray-400">সকল অর্ডার পরিচালনা করুন</p>
            </div>
            <div class="flex gap-3">
                <a href="{{ route('admin.orders') }}?status=all" class="px-4 py-2 rounded-lg {{ request('status', 'all') == 'all' ? 'bg-primary text-white' : 'bg-white/10 text-gray-400' }}">সব</a>
                <a href="{{ route('admin.orders') }}?status=pending" class="px-4 py-2 rounded-lg {{ request('status') == 'pending' ? 'bg-yellow-500 text-white' : 'bg-white/10 text-gray-400' }}">অপেক্ষমাণ</a>
                <a href="{{ route('admin.orders') }}?status=processing" class="px-4 py-2 rounded-lg {{ request('status') == 'processing' ? 'bg-blue-500 text-white' : 'bg-white/10 text-gray-400' }}">প্রক্রিয়াধীন</a>
                <a href="{{ route('admin.orders') }}?status=completed" class="px-4 py-2 rounded-lg {{ request('status') == 'completed' ? 'bg-green-500 text-white' : 'bg-white/10 text-gray-400' }}">সম্পন্ন</a>
            </div>
        </div>
    </div>
</section>

<section class="py-10 bg-dark">
    <div class="container mx-auto px-4">
        <div class="bg-dark-light rounded-2xl border border-white/10 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-white/5">
                        <tr>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">অর্ডার নং</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">সেবা</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">গ্রাহক</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">পরিমাণ</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">স্ট্যাটাস</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">পেমেন্ট</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">তারিখ</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">অ্যাকশন</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-white/5">
                        @forelse($orders as $order)
                        <tr class="hover:bg-white/5 transition-colors">
                            <td class="px-6 py-4">
                                <span class="font-mono text-sm">{{ $order->order_number }}</span>
                            </td>
                            <td class="px-6 py-4">
                                <span class="text-sm">{{ $order->service->name_bn ?? 'N/A' }}</span>
                            </td>
                            <td class="px-6 py-4">
                                <div>
                                    <div class="text-sm font-medium">{{ $order->customer_name }}</div>
                                    <div class="text-xs text-gray-500">{{ $order->customer_phone }}</div>
                                </div>
                            </td>
                            <td class="px-6 py-4 text-sm">
                                @if($order->amount)
                                    ৳{{ number_format($order->amount, 2) }}
                                @else
                                    <span class="text-gray-500">-</span>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                @switch($order->status)
                                    @case('pending')
                                        <span class="inline-flex items-center gap-1 bg-yellow-500/20 text-yellow-400 px-3 py-1 rounded-full text-xs">
                                            <i class="fas fa-clock"></i> অপেক্ষমাণ
                                        </span>
                                        @break
                                    @case('processing')
                                        <span class="inline-flex items-center gap-1 bg-blue-500/20 text-blue-400 px-3 py-1 rounded-full text-xs">
                                            <i class="fas fa-spinner fa-spin"></i> প্রক্রিয়াধীন
                                        </span>
                                        @break
                                    @case('completed')
                                        <span class="inline-flex items-center gap-1 bg-green-500/20 text-green-400 px-3 py-1 rounded-full text-xs">
                                            <i class="fas fa-check-circle"></i> সম্পন্ন
                                        </span>
                                        @break
                                    @case('cancelled')
                                        <span class="inline-flex items-center gap-1 bg-red-500/20 text-red-400 px-3 py-1 rounded-full text-xs">
                                            <i class="fas fa-times-circle"></i> বাতিল
                                        </span>
                                        @break
                                @endswitch
                            </td>
                            <td class="px-6 py-4">
                                @switch($order->payment_status)
                                    @case('pending')
                                        <span class="text-yellow-400 text-xs">অপেক্ষমাণ</span>
                                        @break
                                    @case('paid')
                                        <span class="text-green-400 text-xs">পরিশোধিত</span>
                                        @break
                                    @case('failed')
                                        <span class="text-red-400 text-xs">ব্যর্থ</span>
                                        @break
                                    @case('refunded')
                                        <span class="text-gray-400 text-xs">রিফান্ড</span>
                                        @break
                                @endswitch
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-400">
                                {{ $order->created_at->format('d M, Y') }}
                            </td>
                            <td class="px-6 py-4">
                                <a href="{{ route('admin.orders.show', $order) }}" class="text-primary hover:text-primary/80 text-sm">
                                    <i class="fas fa-eye"></i> দেখুন
                                </a>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="8" class="px-6 py-8 text-center text-gray-400">
                                <i class="fas fa-inbox text-4xl mb-3"></i>
                                <p>কোনো অর্ডার পাওয়া যায়নি</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        
        <div class="mt-6">
            {{ $orders->links() }}
        </div>
    </div>
</section>
@endsection
