@extends('layouts.app')

@section('title', 'Mamun eService')

@section('content')
<!-- Hero Section -->
<section class="relative min-h-[600px] flex items-center overflow-hidden">
    <!-- Background Pattern -->
    <div class="absolute inset-0 bg-gradient-to-br from-dark via-dark-light to-dark">
        <div class="absolute inset-0 opacity-20">
            <div class="absolute top-20 left-10 w-72 h-72 bg-primary/30 rounded-full filter blur-3xl"></div>
            <div class="absolute bottom-20 right-10 w-96 h-96 bg-secondary/30 rounded-full filter blur-3xl"></div>
            <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[500px] h-[500px] bg-accent/20 rounded-full filter blur-3xl"></div>
        </div>
    </div>
    
    <!-- Hero Content -->
    <div class="container mx-auto px-4 relative z-10 py-20">
        <div class="grid lg:grid-cols-2 gap-12 items-center">
            <div class="text-center lg:text-left">
                <div class="inline-flex items-center gap-2 bg-white/10 backdrop-blur-sm px-4 py-2 rounded-full text-sm mb-6">
                    <span class="w-2 h-2 bg-green-400 rounded-full animate-pulse"></span>
                    <span>২৪/৭ সেবা উপলব্ধ</span>
                </div>
                <h1 class="text-4xl md:text-5xl lg:text-6xl font-bold mb-6 leading-tight">
                    বাংলাদেশের সেরা
                    <span class="bg-gradient-to-r from-primary via-secondary to-accent bg-clip-text text-transparent">ডিজিটাল সেবা</span>
                    প্রদানকারী
                </h1>
                <p class="text-gray-400 text-lg mb-8 max-w-xl mx-auto lg:mx-0">
                    আপনার বিশ্বস্ত ডিজিটাল সহযোগী। Meta Service, রিচার্জ, VPN, সরকারি সেবা সব এক প্ল্যাটফর্মে।
                </p>
                <div class="flex flex-col sm:flex-row gap-4 justify-center lg:justify-start">
                    <a href="#services" class="bg-gradient-to-r from-primary to-secondary hover:from-primary/80 hover:to-secondary/80 text-white px-8 py-4 rounded-xl font-semibold transition-all duration-300 hover:scale-105 flex items-center justify-center gap-2">
                        <i class="fas fa-rocket"></i>
                        সেবাসমূহ দেখুন
                    </a>
                    <a href="{{ route('contact') }}" class="bg-white/10 hover:bg-white/20 backdrop-blur-sm text-white px-8 py-4 rounded-xl font-semibold transition-all duration-300 flex items-center justify-center gap-2">
                        <i class="fas fa-phone"></i>
                        যোগাযোগ করুন
                    </a>
                </div>
            </div>
            
            <!-- Hero Image/Animation -->
            <div class="hidden lg:flex justify-center items-center">
                <div class="relative">
                    <div class="w-80 h-80 bg-gradient-to-br from-primary/20 to-secondary/20 rounded-3xl rotate-12 absolute -inset-4"></div>
                    <div class="w-80 h-80 bg-gradient-to-br from-secondary/20 to-accent/20 rounded-3xl -rotate-12 absolute -inset-4"></div>
                    <div class="relative w-80 h-80 bg-dark-light rounded-3xl border border-white/10 flex items-center justify-center">
                        <div class="text-center">
                            <div class="w-24 h-24 bg-gradient-to-br from-primary to-secondary rounded-2xl mx-auto mb-4 flex items-center justify-center">
                                <i class="fas fa-digital-tachograph text-4xl text-white"></i>
                            </div>
                            <h3 class="text-2xl font-bold mb-2">১০০০+</h3>
                            <p class="text-gray-400">সন্তুষ্ট গ্রাহক</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Premium Services Section -->
<section id="services" class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <span class="inline-block bg-primary/20 text-primary px-4 py-2 rounded-full text-sm font-medium mb-4">
                প্রিমিয়াম সেবা
            </span>
            <h2 class="text-3xl md:text-4xl font-bold mb-4">আমাদের প্রিমিয়াম সেবাসমূহ</h2>
            <p class="text-gray-400 max-w-2xl mx-auto">
                আপনার প্রয়োজন অনুযায়ী সেরা ডিজিটাল সমাধান। আমরা আপনার জন্য জনপ্রিয় এবং বিশেষায়িত উভয় ধরণের পরিষেবা সরবরাহ করি।
            </p>
        </div>
        
        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach($featuredServices as $service)
            <div class="group bg-dark-light rounded-2xl overflow-hidden border border-white/10 hover:border-primary/50 transition-all duration-300 hover:-translate-y-2">
                <div class="relative h-48 overflow-hidden">
                    @if($service->image)
                        <img src="{{ asset('storage/' . $service->image) }}" alt="{{ $service->name_bn }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-500">
                    @else
                        <div class="w-full h-full bg-gradient-to-br from-primary/20 to-secondary/20 flex items-center justify-center">
                            <i class="fas fa-cog text-6xl text-primary/50"></i>
                        </div>
                    @endif
                    @if($service->is_popular)
                    <div class="absolute top-4 left-4 bg-gradient-to-r from-orange-500 to-red-500 text-white text-xs px-3 py-1 rounded-full">
                        জনপ্রিয়
                    </div>
                    @endif
                    <div class="absolute inset-0 bg-gradient-to-t from-dark-light to-transparent"></div>
                </div>
                <div class="p-6">
                    <h3 class="text-xl font-bold mb-2">{{ $service->name_bn }}</h3>
                    <p class="text-gray-400 text-sm mb-4 line-clamp-2">{{ $service->short_description_bn }}</p>
                    <div class="flex gap-3">
                        <a href="{{ url('/paid/' . $service->slug) }}" class="flex-1 bg-white/10 hover:bg-white/20 text-white py-2 px-4 rounded-lg text-center text-sm transition-colors">
                            বিস্তারিত দেখুন
                        </a>
                        <a href="{{ url('/paid/' . $service->slug) }}#order-form" class="flex-1 bg-gradient-to-r from-primary to-secondary hover:from-primary/80 hover:to-secondary/80 text-white py-2 px-4 rounded-lg text-center text-sm transition-colors">
                            অর্ডার করুন
                        </a>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        
        <div class="text-center mt-10">
            <a href="{{ route('home') }}#services" class="inline-flex items-center gap-2 bg-white/10 hover:bg-white/20 text-white px-6 py-3 rounded-xl transition-colors">
                সকল প্রিমিয়াম সেবা দেখুন
                <i class="fas fa-arrow-right"></i>
            </a>
        </div>
    </div>
</section>

<!-- Essential Services Section -->
<section class="py-20 bg-dark-light/50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <span class="inline-block bg-secondary/20 text-secondary px-4 py-2 rounded-full text-sm font-medium mb-4">
                প্রয়োজনীয় সেবা
            </span>
            <h2 class="text-3xl md:text-4xl font-bold mb-4">প্রয়োজনীয় সেবাসমূহ</h2>
            <p class="text-gray-400 max-w-2xl mx-auto">
                আপনার দৈনন্দিন জীবনের জন্য গুরুত্বপূর্ণ সকল সেবা।
            </p>
        </div>
        
        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach($freeCategories as $category)
            <a href="{{ url('/free/' . $category->slug) }}" class="group bg-dark rounded-2xl p-6 border border-white/10 hover:border-secondary/50 transition-all duration-300 hover:-translate-y-1">
                <div class="flex items-start gap-4">
                    <div class="w-14 h-14 bg-gradient-to-br from-secondary/20 to-accent/20 rounded-xl flex items-center justify-center flex-shrink-0 group-hover:from-secondary/30 group-hover:to-accent/30 transition-colors">
                        @if($category->icon)
                            <i class="{{ $category->icon }} text-2xl text-secondary"></i>
                        @else
                            <i class="fas fa-folder text-2xl text-secondary"></i>
                        @endif
                    </div>
                    <div>
                        <h3 class="text-lg font-bold mb-2 group-hover:text-secondary transition-colors">{{ $category->name_bn }}</h3>
                        <p class="text-gray-400 text-sm">{{ $category->description_bn ?? $category->services->count() . ' টি সেবা উপলব্ধ' }}</p>
                    </div>
                </div>
                <div class="mt-4 flex items-center text-secondary text-sm">
                    <span>বিস্তারিত দেখুন</span>
                    <i class="fas fa-arrow-right ml-2 group-hover:translate-x-1 transition-transform"></i>
                </div>
            </a>
            @endforeach
        </div>
    </div>
</section>

<!-- VPN/DNS Promotion Section -->
<section class="py-20 bg-dark relative overflow-hidden">
    <div class="absolute inset-0">
        <div class="absolute top-0 right-0 w-1/2 h-full bg-gradient-to-l from-primary/10 to-transparent"></div>
        <div class="absolute bottom-0 left-0 w-96 h-96 bg-accent/10 rounded-full filter blur-3xl"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10">
        <div class="grid lg:grid-cols-2 gap-12 items-center">
            <div>
                <span class="inline-block bg-accent/20 text-accent px-4 py-2 rounded-full text-sm font-medium mb-4">
                    <i class="fas fa-shield-alt mr-2"></i>নিরাপদ সংযোগ
                </span>
                <h2 class="text-3xl md:text-4xl font-bold mb-4">
                    SuAuth VPN ও DNS সার্ভিস
                </h2>
                <p class="text-gray-400 text-lg mb-6">
                    বিদেশে বসে বিকাশ, নগদ সহ যেকোনো বাংলাদেশি সেবা ব্যবহার করুন নিরাপদে ও দ্রুত গতিতে।
                </p>
                <ul class="space-y-3 mb-8">
                    <li class="flex items-center gap-3">
                        <i class="fas fa-check-circle text-green-500"></i>
                        <span class="text-gray-300">১০০% নিরাপদ সংযোগ</span>
                    </li>
                    <li class="flex items-center gap-3">
                        <i class="fas fa-check-circle text-green-500"></i>
                        <span class="text-gray-300">দ্রুত গতির সার্ভার</span>
                    </li>
                    <li class="flex items-center gap-3">
                        <i class="fas fa-check-circle text-green-500"></i>
                        <span class="text-gray-300">২৪/৭ সাপোর্ট</span>
                    </li>
                    <li class="flex items-center gap-3">
                        <i class="fas fa-check-circle text-green-500"></i>
                        <span class="text-gray-300">সহজ সেটআপ</span>
                    </li>
                </ul>
                <div class="flex flex-col sm:flex-row gap-4">
                    <a href="{{ url('/paid/vpn-dns') }}" class="bg-white/10 hover:bg-white/20 text-white px-6 py-3 rounded-xl text-center transition-colors">
                        বিস্তারিত দেখুন
                    </a>
                    <a href="{{ url('/paid/vpn-dns') }}#order-form" class="bg-gradient-to-r from-accent to-secondary hover:from-accent/80 hover:to-secondary/80 text-white px-6 py-3 rounded-xl text-center transition-colors">
                        অর্ডার করুন
                    </a>
                </div>
            </div>
            <div class="hidden lg:flex justify-center">
                <div class="relative">
                    <div class="w-72 h-72 bg-gradient-to-br from-accent/30 to-primary/30 rounded-full filter blur-3xl absolute -inset-8"></div>
                    <div class="relative w-64 h-64 bg-dark-light rounded-3xl border border-white/10 flex items-center justify-center">
                        <div class="text-center">
                            <i class="fas fa-shield-alt text-6xl text-accent mb-4"></i>
                            <h3 class="text-xl font-bold">VPN/DNS</h3>
                            <p class="text-gray-400 text-sm">নিরাপদ সংযোগ</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Government Services Section -->
<section class="py-20 bg-dark-light/50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <span class="inline-block bg-green-500/20 text-green-400 px-4 py-2 rounded-full text-sm font-medium mb-4">
                <i class="fas fa-landmark mr-2"></i>সরকারি সেবা
            </span>
            <h2 class="text-3xl md:text-4xl font-bold mb-4">সরকারি অনলাইন সেবাসমূহ</h2>
            <p class="text-gray-400 max-w-2xl mx-auto">
                আপনার প্রয়োজনীয় সকল সরকারি সেবা এখন আরও সহজে ও দ্রুততার সাথে।
            </p>
        </div>
        
        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach($governmentServices as $service)
            <div class="bg-dark rounded-2xl p-6 border border-white/10 hover:border-green-500/50 transition-all duration-300">
                <h3 class="text-lg font-bold mb-2">{{ $service->name_bn }}</h3>
                <p class="text-gray-400 text-sm mb-4">{{ $service->short_description_bn }}</p>
                <a href="{{ url('/services/' . $service->slug) }}" class="inline-flex items-center text-green-400 hover:text-green-300 text-sm transition-colors">
                    বিস্তারিত দেখুন
                    <i class="fas fa-arrow-right ml-2"></i>
                </a>
            </div>
            @endforeach
        </div>
        
        <div class="text-center mt-10">
            <a href="{{ route('services.index') }}" class="inline-flex items-center gap-2 bg-green-500/20 hover:bg-green-500/30 text-green-400 px-6 py-3 rounded-xl transition-colors">
                সকল সরকারি সেবা দেখুন
                <i class="fas fa-arrow-right"></i>
            </a>
        </div>
    </div>
</section>

<!-- About/Stats Section -->
<section class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        <div class="grid lg:grid-cols-2 gap-12 items-center">
            <div>
                <span class="inline-block bg-primary/20 text-primary px-4 py-2 rounded-full text-sm font-medium mb-4">
                    আমাদের সম্পর্কে
                </span>
                <h2 class="text-3xl md:text-4xl font-bold mb-4">
                    আমরা আপনার ডিজিটাল জীবনকে সহজ করতে প্রতিশ্রুতিবদ্ধ
                </h2>
                <p class="text-gray-400 mb-6">
                    Mamun eService বাংলাদেশের একটি বিশ্বস্ত ডিজিটাল সেবা প্রদানকারী প্রতিষ্ঠান। আমরা আমাদের গ্রাহকদের সেরা মানের সেবা প্রদানের জন্য কাজ করছি। আমাদের পরিসংখ্যান আমাদের কাজের সাক্ষ্য দেয়।
                </p>
                <a href="{{ route('about') }}" class="inline-flex items-center gap-2 text-primary hover:text-primary/80 transition-colors">
                    আরও জানুন
                    <i class="fas fa-arrow-right"></i>
                </a>
            </div>
            
            <div class="grid grid-cols-2 gap-6">
                <div class="bg-dark-light rounded-2xl p-6 text-center border border-white/10">
                    <div class="text-4xl font-bold bg-gradient-to-r from-primary to-secondary bg-clip-text text-transparent mb-2">
                        {{ $stats['customers'] }}+
                    </div>
                    <p class="text-gray-400">সন্তুষ্ট গ্রাহক</p>
                </div>
                <div class="bg-dark-light rounded-2xl p-6 text-center border border-white/10">
                    <div class="text-4xl font-bold bg-gradient-to-r from-secondary to-accent bg-clip-text text-transparent mb-2">
                        {{ $stats['success'] }}+
                    </div>
                    <p class="text-gray-400">সফল সেবা</p>
                </div>
                <div class="bg-dark-light rounded-2xl p-6 text-center border border-white/10">
                    <div class="text-4xl font-bold bg-gradient-to-r from-accent to-primary bg-clip-text text-transparent mb-2">
                        {{ $stats['satisfaction'] }}%
                    </div>
                    <p class="text-gray-400">সন্তুষ্টির হার</p>
                </div>
                <div class="bg-dark-light rounded-2xl p-6 text-center border border-white/10">
                    <div class="text-4xl font-bold bg-gradient-to-r from-primary to-secondary bg-clip-text text-transparent mb-2">
                        {{ $stats['support'] }}
                    </div>
                    <p class="text-gray-400">সাপোর্ট</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Social Links Section -->
<section class="py-20 bg-gradient-to-br from-primary/10 via-secondary/10 to-accent/10">
    <div class="container mx-auto px-4 text-center">
        <h2 class="text-3xl md:text-4xl font-bold mb-4">আমাদের সাথে যুক্ত হোন</h2>
        <p class="text-gray-400 max-w-2xl mx-auto mb-8">
            সর্বশেষ আপডেট এবং অফার পেতে আমাদের চ্যানেলগুলোতে যোগ দিন।
        </p>
        <div class="flex flex-wrap justify-center gap-4">
            <a href="https://whatsapp.com/channel/0029VbB0BofAInPiGTZ9lc0L" target="_blank" class="flex items-center gap-3 bg-green-500 hover:bg-green-600 text-white px-6 py-4 rounded-xl transition-colors">
                <i class="fab fa-whatsapp text-2xl"></i>
                <div class="text-left">
                    <div class="text-sm opacity-80">যোগ দিন</div>
                    <div class="font-semibold">WhatsApp Channel</div>
                </div>
            </a>
            <a href="https://t.me/mamuneservice" target="_blank" class="flex items-center gap-3 bg-blue-500 hover:bg-blue-600 text-white px-6 py-4 rounded-xl transition-colors">
                <i class="fab fa-telegram text-2xl"></i>
                <div class="text-left">
                    <div class="text-sm opacity-80">যোগ দিন</div>
                    <div class="font-semibold">Telegram Channel</div>
                </div>
            </a>
        </div>
    </div>
</section>
@endsection
