@extends('layouts.app')

@section('title', 'ক্যাটাগরি এডিট')

@section('content')
<section class="py-10 bg-dark-light/50 border-b border-white/10">
    <div class="container mx-auto px-4">
        <div class="flex items-center gap-2 text-sm text-gray-400 mb-4">
            <a href="{{ route('admin.dashboard') }}" class="hover:text-white transition-colors">ড্যাশবোর্ড</a>
            <i class="fas fa-chevron-right text-xs"></i>
            <a href="{{ route('admin.categories') }}" class="hover:text-white transition-colors">ক্যাটাগরিসমূহ</a>
            <i class="fas fa-chevron-right text-xs"></i>
            <span>এডিট</span>
        </div>
        <h1 class="text-2xl md:text-3xl font-bold">ক্যাটাগরি এডিট করুন</h1>
    </div>
</section>

<section class="py-10 bg-dark">
    <div class="container mx-auto px-4">
        <div class="max-w-3xl mx-auto">
            <div class="bg-dark-light rounded-2xl p-6 md:p-8 border border-white/10">
                <form action="{{ route('admin.categories.update', $category) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <div class="space-y-6">
                        <div class="grid md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium mb-2">ক্যাটাগরি নাম (English) <span class="text-red-500">*</span></label>
                                <input type="text" name="name" value="{{ $category->name }}" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="Category Name">
                                @error('name')
                                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium mb-2">ক্যাটাগরি নাম (বাংলা) <span class="text-red-500">*</span></label>
                                <input type="text" name="name_bn" value="{{ $category->name_bn }}" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="ক্যাটাগরি নাম">
                                @error('name_bn')
                                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">Slug <span class="text-red-500">*</span></label>
                            <input type="text" name="slug" value="{{ $category->slug }}" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="category-slug">
                            @error('slug')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">বিবরণ (বাংলা)</label>
                            <textarea name="description_bn" rows="3" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="বিবরণ লিখুন...">{{ $category->description_bn }}</textarea>
                            @error('description_bn')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div class="grid md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium mb-2">Icon Class</label>
                                <input type="text" name="icon" value="{{ $category->icon }}" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="fas fa-folder">
                                <p class="text-gray-500 text-xs mt-1">Font Awesome icon class</p>
                                @error('icon')
                                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium mb-2">ছবি</label>
                                @if($category->image)
                                <div class="mb-2">
                                    <img src="{{ asset('storage/' . $category->image) }}" alt="" class="h-20 rounded-lg">
                                </div>
                                @endif
                                <input type="file" name="image" accept="image/*" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:bg-primary file:text-white hover:file:bg-primary/80 transition-colors">
                                @error('image')
                                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="grid md:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-medium mb-2">টাইপ <span class="text-red-500">*</span></label>
                                <select name="type" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white focus:outline-none focus:border-primary transition-colors">
                                    <option value="free" {{ $category->type == 'free' ? 'selected' : '' }}>ফ্রি</option>
                                    <option value="paid" {{ $category->type == 'paid' ? 'selected' : '' }}>পেইড</option>
                                </select>
                                @error('type')
                                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium mb-2">সর্ট অর্ডার</label>
                                <input type="number" name="sort_order" value="{{ $category->sort_order }}" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors">
                                @error('sort_order')
                                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        
                        <div>
                            <label class="flex items-center gap-3 cursor-pointer">
                                <input type="checkbox" name="is_active" value="1" {{ $category->is_active ? 'checked' : '' }} class="w-5 h-5 rounded border-white/10 bg-dark text-primary focus:ring-primary">
                                <span class="text-sm">সক্রিয়</span>
                            </label>
                        </div>
                        
                        <div class="flex gap-4">
                            <button type="submit" class="flex-1 bg-gradient-to-r from-primary to-secondary hover:from-primary/80 hover:to-secondary/80 text-white py-4 rounded-xl font-semibold transition-all duration-300">
                                আপডেট করুন
                            </button>
                            <a href="{{ route('admin.categories') }}" class="px-8 py-4 bg-white/10 hover:bg-white/20 text-white rounded-xl transition-colors">
                                বাতিল
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
@endsection
