<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Service;
use App\Models\Order;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        $featuredServices = Service::active()
            ->paid()
            ->where(function($query) {
                $query->where('is_featured', true)
                      ->orWhere('is_popular', true);
            })
            ->orderBy('sort_order')
            ->take(6)
            ->get();

        $freeCategories = Category::active()
            ->free()
            ->with(['activeServices' => function($query) {
                $query->orderBy('sort_order');
            }])
            ->orderBy('sort_order')
            ->take(6)
            ->get();

        $governmentServices = Service::active()
            ->free()
            ->whereHas('category', function($query) {
                $query->where('slug', 'nagorik-seba');
            })
            ->orderBy('sort_order')
            ->take(6)
            ->get();

        $stats = [
            'customers' => Order::distinct('customer_phone')->count() + 1000,
            'success' => Order::where('status', 'completed')->count() + 2000,
            'satisfaction' => 98,
            'support' => '24/7',
        ];

        return view('home', compact(
            'featuredServices',
            'freeCategories',
            'governmentServices',
            'stats'
        ));
    }

    public function about()
    {
        $stats = [
            'customers' => Order::distinct('customer_phone')->count() + 1000,
            'success' => Order::where('status', 'completed')->count() + 2000,
            'satisfaction' => 98,
            'support' => '24/7',
        ];

        return view('about', compact('stats'));
    }

    public function contact()
    {
        return view('contact');
    }

    public function privacyPolicy()
    {
        return view('privacy-policy');
    }

    public function termsConditions()
    {
        return view('terms-conditions');
    }

    public function refundPolicy()
    {
        return view('refund-policy');
    }
}
