# Mamun eService - Laravel Application

বাংলাদেশের সেরা ডিজিটাল সেবা প্রদানকারী ওয়েবসাইট - Laravel এ তৈরি।

## ফিচারসমূহ

### Frontend
- 🎨 আধুনিক এবং আকর্ষণীয় ডিজাইন
- 📱 সম্পূর্ণ রেসপন্সিভ
- ⚡ দ্রুত লোডিং
- 🔍 SEO ফ্রেন্ডলি
- 🌙 ডার্ক থিম

### Backend (Admin Panel)
- 📊 ড্যাশবোর্ড সহ পরিসংখ্যান
- 🛠️ সেবা ম্যানেজমেন্ট
- 📁 ক্যাটাগরি ম্যানেজমেন্ট
- 📦 অর্ডার ম্যানেজমেন্ট
- 👥 ইউজার ম্যানেজমেন্ট
- 🔐 অথেনটিকেশন সিস্টেম

### সেবাসমূহ
- Meta Service (Facebook, Instagram, WhatsApp)
- রিচার্জ সেবা (Sonido Global, Brilliant Connect)
- VPN/DNS সার্ভার
- সিম রোমিং/রিচার্জ
- গিফট কার্ড/সাবস্ক্রিপশন
- সরকারি সেবাসমূহ (NID, পাসপোর্ট, জন্ম নিবন্ধন ইত্যাদি)

## cPanel এ ইনস্টলেশন

### প্রয়োজনীয়তা
- PHP 8.1 বা উচ্চতর
- MySQL 5.7 বা উচ্চতর
- Composer
- SSL Certificate (সুপারিশকৃত)

### ধাপ ১: ফাইল আপলোড

1. এই প্রজেক্টটি ZIP আকারে ডাউনলোড করুন
2. cPanel-এ লগইন করুন
3. File Manager এ যান
4. `public_html` ফোল্ডারে যান
5. সব ফাইল মুছে ফেলুন (যদি থাকে)
6. ZIP ফাইল আপলোড করুন
7. ZIP ফাইল এক্সট্র্যাক্ট করুন

### ধাপ ২: Database তৈরি

1. cPanel-এ MySQL Databases এ যান
2. একটি নতুন ডেটাবেস তৈরি করুন (যেমন: `mamuneservice`)
3. একটি নতুন ইউজার তৈরি করুন
4. ইউজারকে ডেটাবেসে যোগ করুন (All Privileges)

### ধাপ ৩: Environment সেটআপ

1. File Manager এ `.env.example` ফাইলটি `.env` নামে রিনেম করুন
2. `.env` ফাইলটি এডিট করুন এবং নিচের তথ্যগুলো পরিবর্তন করুন:

```
APP_NAME="Mamun eService"
APP_ENV=production
APP_DEBUG=false
APP_URL=https://yourdomain.com

DB_DATABASE=your_database_name
DB_USERNAME=your_database_user
DB_PASSWORD=your_database_password
```

### ধাপ ৪: Composer Install

1. cPanel-এ Terminal খুলুন
2. নিচের কমান্ডগুলো রান করুন:

```bash
cd ~/public_html
composer install --no-dev --optimize-autoloader
```

অথবা সফটাকুলাস (Softaculous) ব্যবহার করে Laravel ইনস্টল করুন এবং ফাইলগুলো রিপ্লেস করুন।

### ধাপ ৫: Application Key Generate

```bash
php artisan key:generate
```

### ধাপ ৬: Database Migration

```bash
php artisan migrate
```

### ধাপ ৭: Database Seeding

```bash
php artisan db:seed
```

### ধাপ ৮: Storage Link

```bash
php artisan storage:link
```

### ধাপ ৯: Cache Clear

```bash
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

## ডিফল্ট লগইন তথ্য

- **Email:** admin@mamuneservice.com
- **Password:** admin123

**গুরুত্বপূর্ণ:** প্রথম লগইনের পর অবশ্যই পাসওয়ার্ড পরিবর্তন করুন!

## ফোল্ডার স্ট্রাকচার

```
mamuneservice-laravel/
├── app/
│   ├── Http/
│   │   └── Controllers/
│   ├── Models/
│   └── Providers/
├── bootstrap/
├── config/
├── database/
│   ├── migrations/
│   └── seeders/
├── public/
│   ├── css/
│   ├── js/
│   └── .htaccess
├── resources/
│   └── views/
├── routes/
├── storage/
├── .env.example
├── composer.json
└── README.md
```

## সমস্যা সমাধান

### ৫০০ Internal Server Error
- `.env` ফাইলের permission চেক করুন (৬০০)
- `storage` এবং `bootstrap/cache` ফোল্ডারের permission চেক করুন (৭৭৫)

### Database Connection Error
- `.env` ফাইলে ডেটাবেস তথ্য সঠিক কিনা চেক করুন
- ডেটাবেস ইউজারের privileges চেক করুন

### ৪০৪ Not Found
- `.htaccess` ফাইল আছে কিনা চেক করুন
- `mod_rewrite` এনেবল আছে কিনা চেক করুন

## সাপোর্ট

যেকোনো সাহায্যের জন্য যোগাযোগ করুন:
- Email: support@mamuneservice.com
- WhatsApp: +8801886191222

## লাইসেন্স

This project is licensed under the MIT License.

## Credits

Developed with ❤️ in Bangladesh
