@extends('layouts.app')

@section('title', $service->name_bn)

@section('content')
<!-- Page Header -->
<section class="py-20 bg-dark-light/50 relative overflow-hidden">
    <div class="absolute inset-0">
        <div class="absolute top-0 left-0 w-96 h-96 bg-green-500/10 rounded-full filter blur-3xl"></div>
        <div class="absolute bottom-0 right-0 w-96 h-96 bg-blue-500/10 rounded-full filter blur-3xl"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10">
        <div class="text-center max-w-2xl mx-auto">
            <span class="inline-block bg-green-500/20 text-green-400 px-4 py-2 rounded-full text-sm font-medium mb-4">
                {{ $service->category->name_bn ?? 'সরকারি সেবা' }}
            </span>
            <h1 class="text-3xl md:text-5xl font-bold mb-4">{{ $service->name_bn }}</h1>
            <p class="text-gray-400">
                {{ $service->short_description_bn }}
            </p>
        </div>
    </div>
</section>

<!-- Service Links Section -->
<section class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        @if($service->links && $service->links->count() > 0)
        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach($service->links as $link)
            <a href="{{ $link->url }}" target="_blank" class="group bg-dark-light rounded-2xl p-6 border border-white/10 hover:border-green-500/50 transition-all duration-300 hover:-translate-y-1">
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 bg-green-500/20 rounded-xl flex items-center justify-center flex-shrink-0 group-hover:bg-green-500/30 transition-colors">
                        @if($link->icon)
                            <i class="{{ $link->icon }} text-xl text-green-400"></i>
                        @else
                            <i class="fas fa-external-link-alt text-xl text-green-400"></i>
                        @endif
                    </div>
                    <div>
                        <h3 class="font-semibold group-hover:text-green-400 transition-colors">{{ $link->title_bn }}</h3>
                    </div>
                </div>
            </a>
            @endforeach
        </div>
        @else
        <div class="text-center py-12">
            <div class="w-20 h-20 bg-white/5 rounded-full flex items-center justify-center mx-auto mb-4">
                <i class="fas fa-link text-3xl text-gray-500"></i>
            </div>
            <h3 class="text-xl font-semibold mb-2">কোনো লিংক পাওয়া যায়নি</h3>
            <p class="text-gray-400">এই সেবার জন্য এখনো কোনো লিংক যোগ করা হয়নি</p>
        </div>
        @endif
        
        <!-- External Link -->
        @if($service->external_link)
        <div class="mt-10 text-center">
            <a href="{{ $service->external_link }}" target="_blank" class="inline-flex items-center gap-2 bg-green-500 hover:bg-green-600 text-white px-8 py-4 rounded-xl font-semibold transition-colors">
                <i class="fas fa-external-link-alt"></i>
                সরকারি ওয়েবসাইটে যান
            </a>
        </div>
        @endif
    </div>
</section>

<!-- Description Section -->
@if($service->description_bn)
<section class="py-20 bg-dark-light/50">
    <div class="container mx-auto px-4">
        <div class="max-w-3xl mx-auto">
            <h2 class="text-2xl font-bold mb-6">বিস্তারিত তথ্য</h2>
            <div class="prose prose-invert max-w-none">
                {!! nl2br(e($service->description_bn)) !!}
            </div>
        </div>
    </div>
</section>
@endif

<!-- Related Services -->
<section class="py-20 bg-dark">
    <div class="container mx-auto px-4">
        <div class="text-center mb-10">
            <h2 class="text-2xl font-bold mb-4">আরও সেবা</h2>
            <p class="text-gray-400">এই ক্যাটাগরির আরও সেবাসমূহ</p>
        </div>
        
        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach($service->category->services->where('id', '!=', $service->id)->where('is_active', true)->take(6) as $relatedService)
            <a href="{{ url('/services/' . $relatedService->slug) }}" class="group bg-dark-light rounded-2xl p-6 border border-white/10 hover:border-green-500/50 transition-all duration-300">
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 bg-green-500/20 rounded-xl flex items-center justify-center flex-shrink-0">
                        @if($relatedService->icon)
                            <i class="{{ $relatedService->icon }} text-xl text-green-400"></i>
                        @else
                            <i class="fas fa-file-alt text-xl text-green-400"></i>
                        @endif
                    </div>
                    <div>
                        <h3 class="font-semibold group-hover:text-green-400 transition-colors">{{ $relatedService->name_bn }}</h3>
                        <p class="text-gray-400 text-sm line-clamp-1">{{ $relatedService->short_description_bn }}</p>
                    </div>
                </div>
            </a>
            @endforeach
        </div>
    </div>
</section>
@endsection
