@extends('layouts.app')

@section('title', 'লগইন')

@section('content')
<section class="min-h-screen flex items-center justify-center py-20 bg-dark relative overflow-hidden">
    <!-- Background -->
    <div class="absolute inset-0">
        <div class="absolute top-0 left-0 w-96 h-96 bg-primary/10 rounded-full filter blur-3xl"></div>
        <div class="absolute bottom-0 right-0 w-96 h-96 bg-secondary/10 rounded-full filter blur-3xl"></div>
    </div>
    
    <div class="container mx-auto px-4 relative z-10">
        <div class="max-w-md mx-auto">
            <div class="text-center mb-8">
                <a href="{{ route('home') }}" class="inline-flex items-center gap-2 mb-6">
                    <div class="w-12 h-12 bg-gradient-to-br from-primary to-secondary rounded-xl flex items-center justify-center">
                        <span class="text-white font-bold text-xl">M</span>
                    </div>
                </a>
                <h1 class="text-2xl font-bold mb-2">অ্যাডমিন লগইন</h1>
                <p class="text-gray-400">আপনার অ্যাকাউন্টে প্রবেশ করুন</p>
            </div>
            
            <div class="bg-dark-light rounded-2xl p-8 border border-white/10">
                @if($errors->any())
                <div class="bg-red-500/20 border border-red-500/50 text-red-400 px-4 py-3 rounded-xl mb-6">
                    @foreach($errors->all() as $error)
                    <p><i class="fas fa-exclamation-circle mr-2"></i>{{ $error }}</p>
                    @endforeach
                </div>
                @endif
                
                <form action="{{ route('login') }}" method="POST">
                    @csrf
                    
                    <div class="space-y-6">
                        <div>
                            <label class="block text-sm font-medium mb-2">ইমেইল</label>
                            <input type="email" name="email" value="{{ old('email') }}" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="your@email.com">
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium mb-2">পাসওয়ার্ড</label>
                            <input type="password" name="password" required class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="••••••••">
                        </div>
                        
                        <div class="flex items-center justify-between">
                            <label class="flex items-center gap-2 cursor-pointer">
                                <input type="checkbox" name="remember" class="w-4 h-4 rounded border-white/10 bg-dark text-primary focus:ring-primary">
                                <span class="text-sm text-gray-400">মনে রাখুন</span>
                            </label>
                        </div>
                        
                        <button type="submit" class="w-full bg-gradient-to-r from-primary to-secondary hover:from-primary/80 hover:to-secondary/80 text-white py-4 rounded-xl font-semibold transition-all duration-300">
                            লগইন করুন
                        </button>
                    </div>
                </form>
                
                <div class="mt-6 text-center">
                    <a href="{{ route('home') }}" class="text-gray-400 hover:text-white text-sm transition-colors">
                        <i class="fas fa-arrow-left mr-2"></i>হোমে ফিরে যান
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
