@extends('layouts.app')

@section('title', 'সেবাসমূহ')

@section('content')
<section class="py-10 bg-dark-light/50 border-b border-white/10">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <div>
                <h1 class="text-2xl md:text-3xl font-bold">সেবাসমূহ</h1>
                <p class="text-gray-400">সকল সেবা পরিচালনা করুন</p>
            </div>
            <a href="{{ route('admin.services.create') }}" class="bg-gradient-to-r from-primary to-secondary hover:from-primary/80 hover:to-secondary/80 text-white px-6 py-3 rounded-xl transition-colors flex items-center gap-2">
                <i class="fas fa-plus"></i>
                নতুন সেবা
            </a>
        </div>
    </div>
</section>

<section class="py-10 bg-dark">
    <div class="container mx-auto px-4">
        <div class="bg-dark-light rounded-2xl border border-white/10 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-white/5">
                        <tr>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">#</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">সেবা</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">ক্যাটাগরি</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">টাইপ</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">দাম</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">স্ট্যাটাস</th>
                            <th class="text-left px-6 py-4 text-sm font-medium text-gray-400">অ্যাকশন</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-white/5">
                        @forelse($services as $service)
                        <tr class="hover:bg-white/5 transition-colors">
                            <td class="px-6 py-4 text-sm text-gray-400">{{ $service->id }}</td>
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    @if($service->image)
                                        <img src="{{ asset('storage/' . $service->image) }}" alt="" class="w-10 h-10 rounded-lg object-cover">
                                    @else
                                        <div class="w-10 h-10 bg-primary/20 rounded-lg flex items-center justify-center">
                                            <i class="fas fa-cog text-primary"></i>
                                        </div>
                                    @endif
                                    <div>
                                        <div class="font-medium">{{ $service->name_bn }}</div>
                                        <div class="text-xs text-gray-500">{{ $service->name }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 text-sm">{{ $service->category->name_bn ?? 'N/A' }}</td>
                            <td class="px-6 py-4">
                                @if($service->type === 'paid')
                                    <span class="bg-primary/20 text-primary px-3 py-1 rounded-full text-xs">পেইড</span>
                                @else
                                    <span class="bg-green-500/20 text-green-400 px-3 py-1 rounded-full text-xs">ফ্রি</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 text-sm">
                                @if($service->price)
                                    ৳{{ number_format($service->price, 2) }}
                                @else
                                    <span class="text-gray-500">-</span>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                @if($service->is_active)
                                    <span class="bg-green-500/20 text-green-400 px-3 py-1 rounded-full text-xs">সক্রিয়</span>
                                @else
                                    <span class="bg-red-500/20 text-red-400 px-3 py-1 rounded-full text-xs">নিষ্ক্রিয়</span>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-2">
                                    <a href="{{ route('admin.services.edit', $service) }}" class="w-8 h-8 bg-blue-500/20 text-blue-400 rounded-lg flex items-center justify-center hover:bg-blue-500/30 transition-colors">
                                        <i class="fas fa-edit text-sm"></i>
                                    </a>
                                    <form action="{{ route('admin.services.delete', $service) }}" method="POST" onsubmit="return confirm('আপনি কি নিশ্চিত?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="w-8 h-8 bg-red-500/20 text-red-400 rounded-lg flex items-center justify-center hover:bg-red-500/30 transition-colors">
                                            <i class="fas fa-trash text-sm"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="7" class="px-6 py-8 text-center text-gray-400">
                                <i class="fas fa-inbox text-4xl mb-3"></i>
                                <p>কোনো সেবা পাওয়া যায়নি</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        
        <div class="mt-6">
            {{ $services->links() }}
        </div>
    </div>
</section>
@endsection
