@extends('layouts.app')

@section('title', 'অর্ডার বিস্তারিত')

@section('content')
<section class="py-10 bg-dark-light/50 border-b border-white/10">
    <div class="container mx-auto px-4">
        <div class="flex items-center gap-2 text-sm text-gray-400 mb-4">
            <a href="{{ route('admin.dashboard') }}" class="hover:text-white transition-colors">ড্যাশবোর্ড</a>
            <i class="fas fa-chevron-right text-xs"></i>
            <a href="{{ route('admin.orders') }}" class="hover:text-white transition-colors">অর্ডারসমূহ</a>
            <i class="fas fa-chevron-right text-xs"></i>
            <span>{{ $order->order_number }}</span>
        </div>
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <div>
                <h1 class="text-2xl md:text-3xl font-bold">অর্ডার বিস্তারিত</h1>
                <p class="text-gray-400 font-mono">{{ $order->order_number }}</p>
            </div>
            <div class="flex gap-3">
                @switch($order->status)
                    @case('pending')
                        <span class="bg-yellow-500/20 text-yellow-400 px-4 py-2 rounded-lg">
                            <i class="fas fa-clock mr-2"></i>অপেক্ষমাণ
                        </span>
                        @break
                    @case('processing')
                        <span class="bg-blue-500/20 text-blue-400 px-4 py-2 rounded-lg">
                            <i class="fas fa-spinner fa-spin mr-2"></i>প্রক্রিয়াধীন
                        </span>
                        @break
                    @case('completed')
                        <span class="bg-green-500/20 text-green-400 px-4 py-2 rounded-lg">
                            <i class="fas fa-check-circle mr-2"></i>সম্পন্ন
                        </span>
                        @break
                    @case('cancelled')
                        <span class="bg-red-500/20 text-red-400 px-4 py-2 rounded-lg">
                            <i class="fas fa-times-circle mr-2"></i>বাতিল
                        </span>
                        @break
                @endswitch
            </div>
        </div>
    </div>
</section>

<section class="py-10 bg-dark">
    <div class="container mx-auto px-4">
        <div class="grid lg:grid-cols-3 gap-8">
            <!-- Order Details -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Customer Info -->
                <div class="bg-dark-light rounded-2xl p-6 border border-white/10">
                    <h2 class="text-lg font-bold mb-4">গ্রাহকের তথ্য</h2>
                    <div class="grid md:grid-cols-2 gap-4">
                        <div>
                            <p class="text-gray-400 text-sm mb-1">নাম</p>
                            <p class="font-medium">{{ $order->customer_name }}</p>
                        </div>
                        <div>
                            <p class="text-gray-400 text-sm mb-1">ফোন</p>
                            <p class="font-medium">{{ $order->customer_phone }}</p>
                        </div>
                        @if($order->customer_email)
                        <div>
                            <p class="text-gray-400 text-sm mb-1">ইমেইল</p>
                            <p class="font-medium">{{ $order->customer_email }}</p>
                        </div>
                        @endif
                        <div>
                            <p class="text-gray-400 text-sm mb-1">অর্ডার তারিখ</p>
                            <p class="font-medium">{{ $order->created_at->format('d M, Y h:i A') }}</p>
                        </div>
                    </div>
                </div>
                
                <!-- Service Details -->
                <div class="bg-dark-light rounded-2xl p-6 border border-white/10">
                    <h2 class="text-lg font-bold mb-4">সেবার তথ্য</h2>
                    <div class="grid md:grid-cols-2 gap-4">
                        <div>
                            <p class="text-gray-400 text-sm mb-1">সেবা</p>
                            <p class="font-medium">{{ $order->service->name_bn ?? 'N/A' }}</p>
                        </div>
                        @if($order->platform)
                        <div>
                            <p class="text-gray-400 text-sm mb-1">প্ল্যাটফর্ম</p>
                            <p class="font-medium">{{ ucfirst($order->platform) }}</p>
                        </div>
                        @endif
                        @if($order->service_type)
                        <div>
                            <p class="text-gray-400 text-sm mb-1">সেবার ধরন</p>
                            <p class="font-medium">{{ ucfirst(str_replace('-', ' ', $order->service_type)) }}</p>
                        </div>
                        @endif
                        @if($order->priority)
                        <div>
                            <p class="text-gray-400 text-sm mb-1">অগ্রাধিকার</p>
                            <p class="font-medium">{{ $order->priority == 'urgent' ? 'জরুরি' : 'সাধারণ' }}</p>
                        </div>
                        @endif
                        @if($order->id_link)
                        <div class="md:col-span-2">
                            <p class="text-gray-400 text-sm mb-1">আইডি লিংক</p>
                            <a href="{{ $order->id_link }}" target="_blank" class="text-primary hover:text-primary/80 break-all">{{ $order->id_link }}</a>
                        </div>
                        @endif
                    </div>
                </div>
                
                <!-- Order Details -->
                @if($order->details)
                <div class="bg-dark-light rounded-2xl p-6 border border-white/10">
                    <h2 class="text-lg font-bold mb-4">বিস্তারিত বিবরণ</h2>
                    <p class="text-gray-400">{{ $order->details }}</p>
                </div>
                @endif
                
                <!-- Document -->
                @if($order->document)
                <div class="bg-dark-light rounded-2xl p-6 border border-white/10">
                    <h2 class="text-lg font-bold mb-4">ডকুমেন্ট</h2>
                    <a href="{{ asset('storage/' . $order->document) }}" target="_blank" class="inline-flex items-center gap-2 bg-primary/20 text-primary px-4 py-2 rounded-lg hover:bg-primary/30 transition-colors">
                        <i class="fas fa-file"></i>
                        ডকুমেন্ট দেখুন
                    </a>
                </div>
                @endif
            </div>
            
            <!-- Sidebar -->
            <div class="space-y-6">
                <!-- Payment Info -->
                <div class="bg-dark-light rounded-2xl p-6 border border-white/10">
                    <h2 class="text-lg font-bold mb-4">পেমেন্ট তথ্য</h2>
                    <div class="space-y-3">
                        <div class="flex justify-between">
                            <span class="text-gray-400">পরিমাণ</span>
                            <span class="font-medium">
                                @if($order->amount)
                                    ৳{{ number_format($order->amount, 2) }}
                                @else
                                    <span class="text-gray-500">-</span>
                                @endif
                            </span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-400">পেমেন্ট স্ট্যাটাস</span>
                            <span>
                                @switch($order->payment_status)
                                    @case('pending')
                                        <span class="text-yellow-400">অপেক্ষমাণ</span>
                                        @break
                                    @case('paid')
                                        <span class="text-green-400">পরিশোধিত</span>
                                        @break
                                    @case('failed')
                                        <span class="text-red-400">ব্যর্থ</span>
                                        @break
                                    @case('refunded')
                                        <span class="text-gray-400">রিফান্ড</span>
                                        @break
                                @endswitch
                            </span>
                        </div>
                    </div>
                </div>
                
                <!-- Update Status -->
                <div class="bg-dark-light rounded-2xl p-6 border border-white/10">
                    <h2 class="text-lg font-bold mb-4">স্ট্যাটাস আপডেট</h2>
                    <form action="{{ route('admin.orders.status', $order) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-medium mb-2">অর্ডার স্ট্যাটাস</label>
                                <select name="status" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white focus:outline-none focus:border-primary transition-colors">
                                    <option value="pending" {{ $order->status == 'pending' ? 'selected' : '' }}>অপেক্ষমাণ</option>
                                    <option value="processing" {{ $order->status == 'processing' ? 'selected' : '' }}>প্রক্রিয়াধীন</option>
                                    <option value="completed" {{ $order->status == 'completed' ? 'selected' : '' }}>সম্পন্ন</option>
                                    <option value="cancelled" {{ $order->status == 'cancelled' ? 'selected' : '' }}>বাতিল</option>
                                </select>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium mb-2">পেমেন্ট স্ট্যাটাস</label>
                                <select name="payment_status" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white focus:outline-none focus:border-primary transition-colors">
                                    <option value="pending" {{ $order->payment_status == 'pending' ? 'selected' : '' }}>অপেক্ষমাণ</option>
                                    <option value="paid" {{ $order->payment_status == 'paid' ? 'selected' : '' }}>পরিশোধিত</option>
                                    <option value="failed" {{ $order->payment_status == 'failed' ? 'selected' : '' }}>ব্যর্থ</option>
                                    <option value="refunded" {{ $order->payment_status == 'refunded' ? 'selected' : '' }}>রিফান্ড</option>
                                </select>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium mb-2">অ্যাডমিন নোট</label>
                                <textarea name="admin_notes" rows="3" class="w-full bg-dark border border-white/10 rounded-xl px-4 py-3 text-white placeholder-gray-500 focus:outline-none focus:border-primary transition-colors" placeholder="নোট লিখুন...">{{ $order->admin_notes }}</textarea>
                            </div>
                            
                            <button type="submit" class="w-full bg-gradient-to-r from-primary to-secondary hover:from-primary/80 hover:to-secondary/80 text-white py-3 rounded-xl font-semibold transition-colors">
                                আপডেট করুন
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
