<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'name',
        'name_bn',
        'slug',
        'short_description',
        'short_description_bn',
        'description',
        'description_bn',
        'image',
        'icon',
        'type',
        'price',
        'discount_price',
        'is_featured',
        'is_popular',
        'is_active',
        'sort_order',
        'external_link',
        'features',
        'features_bn',
    ];

    protected $casts = [
        'is_featured' => 'boolean',
        'is_popular' => 'boolean',
        'is_active' => 'boolean',
        'price' => 'decimal:2',
        'discount_price' => 'decimal:2',
        'features' => 'array',
        'features_bn' => 'array',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function links()
    {
        return $this->hasMany(ServiceLink::class);
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeFeatured($query)
    {
        return $query->where('is_featured', true);
    }

    public function scopePopular($query)
    {
        return $query->where('is_popular', true);
    }

    public function scopeFree($query)
    {
        return $query->where('type', 'free');
    }

    public function scopePaid($query)
    {
        return $query->where('type', 'paid');
    }

    public function getRouteKeyName()
    {
        return 'slug';
    }
}
